; HW_msgbox.asm - hello world from a message box, just about the simplest
; Win32 program you can get
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]
;
; WinMain is where the program starts; it can, in fact, be named
; anything but by tradition it is WinMain. When we link the object
; file (after assembly) we tell the linker where the program starts
; (the program 'entry point'), and this will be whatever label we
; use in the source to mark the start of the program. Ie we use
; WinMain.
;
; WinMain itself is a procedure that is called by Windows, and
; has parameters passed to it:
;
;   1. hInstance - handle of current instance
;   2. hPrevInstance - handle of previous instance (always NULL)
;   3. lpszCmdLine - pointer to the command line string
;   4. nCmdShow - how the window should be displayed
;
; You can of course use different names for the parameters if
; you really want to.
;
; Note the use of procglobal to ensure that the correct label
; is made available to the linker.
;

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	;
	; At the start of the program, we call the special macro
	; WinMainPrologue which sets up the passed parameters to
	; hold the correct values and preserves any registers that
	; Windows requires (the values need a little extra work
	; on them from the raw values Windows passes)
	;
	WinMainPrologue
	;
	; To display a message box, we call the MessageBox
	; function, as defined in the Win32 API. The first
	; argument is normally a window handle, but we don't
	; worry about this here - we've no window - so we pass a
	; NULL value instead. The second and third arguments are
	; the message box text and title respectively, which we
	; pass via their addresses, whilst the fourth changes the
	; look of the message box. You could easily substitute
	; another combination, eg MB_OKCANCEL | MB_ICONHAND
	;
	; Before showing how we actually call the API function, let's
	; consider how we define the strings themselves, as they occur
	; throughout Win32 programming.
	;
	; Almost all strings under Win32 are null-terminated so we've
	; always got to remember to append a 0 to the end of any we
	; define. However, we need to be careful as under Win32, many
	; API calls _expect_ data to be dword aligned and with strings
	; being of variable length they often finish on a non-aligned
	; boundary.
	;
	; Is this alignment _that_ important I can hear you say. Yes,
	; many API calls behave erratically to say the least if they're
	; expecting aligned data and don't get it. It's a lot easier to
	; align your data than try to work out why your app's crashing
	; for no apparent reason.
	;
	; To cope with this, there is a TEXTAL macro we can call which
	; defines the data and then aligns to a dword boundary - so the
	; _next_ piece of data after the string is aligned.
	;
	; Read that again - it's the _next_ piece of data that will be
	; aligned. So, for example:
	;
	;   _sometext    TEXTAL 'Line 1...',10,13,'Line 2...',0
	;
	; However, consider:
	;
	;   _sometext    TEXTAL 'Line 1...',10,13
	;                TEXTAL 'Line 2...',0
	;
	; In this case, the second line will start at a dword aligned
	; address, and the first line won't actually fill up to that
	; address, leaving a gap of a byte. To cope with this, there is
	; the corresponding macro TEXT:
	;
	;   _sometext    TEXT   'Line 1...',10,13
	;                TEXTAL 'Line 2...',0
	;
	; The TEXT macro does the same as TEXTAL except doesn't align.
	;
	; But why go to all this trouble? Surely we can do this ourselves
	; anyway? Well, yes, but it's more convenient to not have to worry,
	; we can easily change the alignment if we want to and, most
	; important of all, if we decide to make a Unicode version of our
	; application we don't need to go through and change all our strings,
	; which would be an enormous pain.
	;
	; So, all we do now is go to the data section and add in our
	; strings, right?
	;
	; Maybe. If your source code is of any size, this begins to get
	; exceedingly irritating. Instead, you can use the TEXTlocal
	; macro (inside a procedure that is) which takes two parameters -
	; the local string name and the string itself:
	;
	;   TEXTlocal _sometext, 'Line 1...',10,13,'Line 2...',0
	;
	; Like local variables, you can only refer to this local string
	; by prefixing the name with a dot character. The macro itself
	; puts the string into the data section in a way so that it's
	; only visible to the local procedure itself. Even though it's
	; got no AL in the name, it does in fact align after inserting
	; the data, so don't panic thinking I've forgotten. For more
	; convenience, the macro also declares another variable - the
	; name prefixed with two dot characters which corresponds to
	; the first byte after the string.
	;
	; Hence, you now have local strings, which can be defined
	; anywhere within a procedure, and global strings.
	;
	; For convenience, there is also a TEXTglobal macro which
	; defines a global variable with the name passed to it, eg:
	;
	;   TEXTglobal _sometext, 'Line 1...',0
	;
	; and then refer to it by:
	;
	;   mov esi, _sometext
	;
	TEXTlocal szMsgBoxTitle, "Hello, world!",0
	TEXTlocal szMsgBoxText, "Hello, world from x86 assembler!",0
	sc MessageBox, NULL, .szMsgBoxText, .szMsgBoxTitle, MB_OK
	;
	; Remember that you don't have to use the sc macro, you
	; can use api, invoke or stdcall instead.
	;
	; At the end of the program, we call the special macro
	; WinMainEpilogue which exits the program. Before we
	; do that, we set eax to zero. When a program exits,
	; whatever is in eax is the program's 'return code',
	; which basically states whether the program ran ok
	; or failed. It isn't of importance here, but becomes
	; more so when one program calls another.
	;
	xor	eax,eax
	WinMainEpilogue
endproc

[section .bss]

[section .data]
